/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MainFrame
extends JFrame {
    private Converter converter = new Converter();
    private JTextField boxInput;
    private JButton btnClose;
    private JComboBox conFrom;
    private JComboBox conTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel lbConvTo;
    private JLabel lbConverted;
    private JLabel lbTotalUnits;
    private JLabel lbUnitName;

    public MainFrame() {
        this.initComponents();
        this.setLocationRelativeTo(this.getRootPane());
        this.converter = new Config().returnConfig();
        this.lbTotalUnits.setText("total units: " + Integer.toString(this.converter.getTotalUnits()));
        String[] allItems = this.converter.getAllUnitNames();
        this.conFrom.setModel(new DefaultComboBoxModel<String>(allItems));
        this.conTo.setModel(new DefaultComboBoxModel<String>(allItems));
        this.conFrom.setSelectedItem("m");
        this.conTo.setSelectedItem("cm");
        this.lbUnitName.setText(this.conTo.getSelectedItem().toString());
        this.lbConvTo.setText(this.converter.getUnitComment(this.conTo.getSelectedItem().toString()));
    }

    private void setResultText(String text, boolean isErrMsg) {
        this.lbConverted.setText(text);
        if (!isErrMsg) {
            this.lbUnitName.setText(this.conTo.getSelectedItem().toString());
        } else {
            this.lbUnitName.setText(null);
        }
    }

    private void convertAndShow() {
        Double inputVal = 0.0;
        try {
            if (this.boxInput.getText().length() < 1) {
                this.setResultText("Mus\u00edte zadat n\u011bjakou hodnotu.", true);
                return;
            }
            inputVal = Double.parseDouble(this.boxInput.getText());
        }
        catch (Exception e) {
            this.setResultText("P\u0159ev\u00e9st lze pouze \u010d\u00edslo!", true);
            return;
        }
        inputVal = this.converter.getConvertResult(inputVal, this.conFrom.getSelectedItem().toString(), this.conTo.getSelectedItem().toString());
        if (inputVal.isInfinite()) {
            this.setResultText("V\u00fdsledek je \"nekone\u010dn\u00fd\" na zobrazen\u00ed :(", true);
            return;
        }
        if (inputVal.isNaN()) {
            this.setResultText("N\u011bkde nastala chyba! Zkusto to znovu.", true);
            return;
        }
        this.setResultText(Double.toString(inputVal), false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.conFrom = new JComboBox();
        this.jLabel2 = new JLabel();
        this.conTo = new JComboBox();
        this.lbConverted = new JLabel();
        this.jLabel4 = new JLabel();
        this.btnClose = new JButton();
        this.jLabel3 = new JLabel();
        this.boxInput = new JTextField();
        this.jLabel5 = new JLabel();
        this.lbTotalUnits = new JLabel();
        this.lbUnitName = new JLabel();
        this.jLabel6 = new JLabel();
        this.lbConvTo = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("P\u0159evody jednotek d\u00e9lky");
        this.setBackground(new Color(204, 204, 204));
        this.setIconImages(null);
        this.setResizable(false);
        this.jLabel1.setFont(new Font("Verdana", 0, 11));
        this.jLabel1.setText("P\u0159evod:");
        this.conFrom.setFont(new Font("Verdana", 0, 11));
        this.conFrom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MainFrame.this.conFromItemStateChanged(evt);
            }
        });
        this.jLabel2.setFont(new Font("Verdana", 1, 11));
        this.jLabel2.setText("do");
        this.conTo.setFont(new Font("Verdana", 0, 11));
        this.conTo.setMinimumSize(new Dimension(57, 22));
        this.conTo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MainFrame.this.conToItemStateChanged(evt);
            }
        });
        this.lbConverted.setFont(new Font("Verdana", 1, 18));
        this.lbConverted.setForeground(new Color(0, 51, 102));
        this.lbConverted.setText("0.0");
        this.lbConverted.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.lbConvertedMouseClicked(evt);
            }
        });
        this.jLabel4.setFont(new Font("Verdana", 0, 11));
        this.jLabel4.setText("V\u00fdsledek:");
        this.btnClose.setText("Konec");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCloseActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Verdana", 0, 11));
        this.jLabel3.setText("Hodnota:");
        this.boxInput.setFont(new Font("Verdana", 0, 11));
        this.boxInput.setText("0");
        this.boxInput.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                MainFrame.this.boxInputCaretUpdate(evt);
            }
        });
        this.jLabel5.setFont(new Font("Verdana", 0, 9));
        this.jLabel5.setForeground(new Color(102, 102, 102));
        this.jLabel5.setText("created by Ji\u0159\u00ed Vik | 2011");
        this.lbTotalUnits.setFont(new Font("Verdana", 0, 9));
        this.lbTotalUnits.setText("total units: 0");
        this.lbUnitName.setFont(new Font("Verdana", 1, 14));
        this.lbUnitName.setForeground(new Color(102, 0, 0));
        this.lbUnitName.setText("NULL");
        this.jLabel6.setFont(new Font("Verdana", 0, 11));
        this.jLabel6.setText("P\u0159evod do:");
        this.lbConvTo.setFont(new Font("Verdana", 1, 11));
        this.lbConvTo.setText("NULL");
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/logo.png")));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.boxInput, -1, 412, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conFrom, -2, 188, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conTo, -2, 188, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbConverted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbUnitName)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbConvTo)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.lbTotalUnits)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 277, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.boxInput, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.conFrom, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.conTo, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.lbConverted).addComponent(this.lbUnitName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.lbConvTo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.lbTotalUnits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose))).addContainerGap()));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void conToItemStateChanged(ItemEvent evt) {
        this.convertAndShow();
        if (this.boxInput.getText().length() > 0) {
            this.lbUnitName.setText(this.conTo.getSelectedItem().toString());
        }
        this.lbConvTo.setText(this.converter.getUnitComment(this.conTo.getSelectedItem().toString()));
    }

    private void conFromItemStateChanged(ItemEvent evt) {
        this.convertAndShow();
    }

    private void boxInputCaretUpdate(CaretEvent evt) {
        this.convertAndShow();
    }

    private void lbConvertedMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 2) {
            String temp = this.lbConverted.getText();
            this.boxInput.setText(this.lbConverted.getText());
            this.lbConverted.setText(temp);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

