/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.List;

final class Converter {
    private List<Unit> units = new LinkedList<Unit>();

    Converter() {
    }

    private double getUnitValue(String unitName) {
        for (Unit it : this.units) {
            if (!it.getUnitName().equals(unitName)) continue;
            return it.getUnitSize();
        }
        return Double.NaN;
    }

    public int getTotalUnits() {
        return this.units.size();
    }

    public String[] getAllUnitNames() {
        String[] buffer = new String[this.units.size()];
        int i = 0;
        for (Unit it : this.units) {
            buffer[i++] = it.getUnitName();
        }
        return buffer;
    }

    public String getUnitComment(String unitName) {
        for (Unit it : this.units) {
            if (!it.getUnitName().equals(unitName)) continue;
            return it.getUnitComment();
        }
        return null;
    }

    public double getConvertResult(double value, String from, String to) {
        Double fromVal = this.getUnitValue(from);
        Double toVal = this.getUnitValue(to);
        if (fromVal.isNaN() || toVal.isNaN()) {
            return Double.NaN;
        }
        return value * fromVal / toVal;
    }

    public void addUnit(Unit unit) {
        this.units.add(unit);
    }
}

